--> pralable
-- USE BD_Air_France;


IF OBJECT_ID('dbo.T_pilote_pil','U') IS NOT NULL
   DROP TABLE dbo.T_pilote_pil;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO


CREATE TABLE T_compagnie_cmp
(cmp_comp VARCHAR(4), cmp_pays CHAR(3), cmp_nom VARCHAR(15),
 CONSTRAINT pk_compagnie PRIMARY KEY(cmp_comp));
GO

CREATE TABLE T_pilote_pil
(pil_brevet VARCHAR(6), pil_prenom VARCHAR(15), pil_nom VARCHAR(15), 
 pil_hvol DECIMAL(7,2), cmp_comp VARCHAR(4), pil_chef VARCHAR(6),
 CONSTRAINT pk_pilote PRIMARY KEY(pil_brevet),
 CONSTRAINT fk_pil_cmp FOREIGN KEY(cmp_comp) REFERENCES T_compagnie_cmp(cmp_comp),
 CONSTRAINT fk_pil_chef_pil FOREIGN KEY(pil_chef) REFERENCES T_pilote_pil(pil_brevet));
GO


INSERT INTO T_compagnie_cmp VALUES ('AF', 'fr', 'Air France');
INSERT INTO T_compagnie_cmp VALUES ('SING','sn', 'Singapore AL');
INSERT INTO T_compagnie_cmp VALUES ('CAST', 'fr', 'Castanet AL');

INSERT INTO T_pilote_pil VALUES ('PL-4', 'Henri','Alqui', 3400, 'AF',NULL);
INSERT INTO T_pilote_pil VALUES ('PL-1', 'Pierre','Lamothe', 450, 'AF', 'PL-4');
INSERT INTO T_pilote_pil VALUES ('PL-2', 'Didier','Linxe', 900, 'AF','PL-4');
INSERT INTO T_pilote_pil VALUES ('PL-3', 'Christian','Soutou', 1000, 'SING',NULL);


SELECT  p.pil_brevet, p.pil_prenom, p.pil_nom
	FROM T_pilote_pil p JOIN T_compagnie_cmp c ON p.cmp_comp = c.cmp_comp 
	WHERE c.cmp_nom    = 'Air France'
	AND   p.pil_hvol      > 500; 

SELECT  p.pil_brevet, p.pil_prenom, p.pil_nom
	FROM T_pilote_pil p INNER JOIN T_compagnie_cmp c ON p.cmp_comp = c.cmp_comp 
	WHERE c.cmp_nom    = 'Air France'
	AND   p.pil_hvol      > 500;

SELECT  p.pil_brevet, p.pil_prenom, p.pil_nom
	FROM   T_pilote_pil p, T_compagnie_cmp c
	WHERE p.cmp_comp    = c.cmp_comp    
	AND   c.cmp_nom     = 'Air France'
	AND   p.pil_hvol      > 500;

-- sous requte

SELECT  pil_brevet, pil_prenom, pil_nom
FROM    T_pilote_pil 
WHERE   cmp_comp  =
        (SELECT  cmp_comp FROM T_compagnie_cmp
	 WHERE   cmp_nom     = 'Air France')
AND      pil_hvol > 500;

-- 

SELECT c.cmp_nom, c.cmp_pays
FROM   T_compagnie_cmp c 
INNER JOIN T_pilote_pil p 
ON    c.cmp_comp = p.cmp_comp
WHERE  p.pil_hvol > 950;

SELECT  c.cmp_nom, c.cmp_pays
FROM    T_pilote_pil p, T_compagnie_cmp c
WHERE   c.cmp_comp = p.cmp_comp
AND     p.pil_hvol > 950;

-- sous requte

SELECT  cmp_nom, cmp_pays
FROM    T_compagnie_cmp
WHERE   cmp_comp  IN
(SELECT  cmp_comp FROM T_pilote_pil
WHERE   pil_hvol > 950);

-- Auto jointures

SELECT  p1.pil_brevet, p1.pil_nom 
FROM    T_pilote_pil p1 
JOIN    T_pilote_pil p2 
ON      p1.pil_chef = p2.pil_brevet
WHERE   p2.pil_nom ='Alqui';

/* relationnelle */

SELECT p1.pil_brevet, p1.pil_nom 
FROM   T_pilote_pil p1, T_pilote_pil p2
WHERE  p1.pil_chef = p2.pil_brevet
AND    p2.pil_nom ='Alqui';

-- sous requte

SELECT  pil_brevet, pil_nom
FROM    T_pilote_pil 
WHERE   pil_chef =
(SELECT  pil_brevet FROM T_pilote_pil 
WHERE   pil_nom ='Alqui');

--

SELECT SUM(p1.pil_hvol) AS "Total"
FROM   T_pilote_pil p1 
JOIN   T_pilote_pil p2 
ON     p1.pil_chef = p2.pil_brevet
JOIN   T_compagnie_cmp c
ON     c.cmp_comp = p2.cmp_comp
WHERE  c.cmp_nom = 'Air France';

/* relationnelle */

SELECT SUM(p1.pil_hvol) AS "Total"
FROM   T_pilote_pil p1, T_pilote_pil p2, T_compagnie_cmp c
WHERE  p1.pil_chef = p2.pil_brevet
AND    c.cmp_comp = p2.cmp_comp
AND    c.cmp_nom = 'Air France';

-- sous requte

SELECT SUM(pil_hvol) AS "Total"
FROM   T_pilote_pil
WHERE  pil_chef IN 
(SELECT pil_brevet
 FROM   T_pilote_pil 
 WHERE  cmp_comp = 
 (SELECT cmp_comp
  FROM   T_compagnie_cmp
  WHERE  cmp_nom = 'Air France'));



